<?php

namespace UtillzCore\Inc\Src;

use \UtillzCore\Inc\Src\Listing\Listing;
use \UtillzCore\Inc\Src\Validation;

class Post_Types {

    use \UtillzCore\Inc\Src\Traits\Singleton;

    function __construct() {

        add_action( 'init', [ $this, 'register_post_types' ] );
        add_action( 'init', [ $this, 'register_post_status' ], 12 );
        add_action( 'admin_init', [ $this, 'approve_listing' ] );

        add_action( 'save_post', [ $this, 'listing_status_change' ] );

        // on listing insert
        add_action( 'wp_insert_post', [ $this, 'insert_listing' ], 10, 3 );

        foreach([ 'post', 'post-new' ] as $hook ) {
			add_action( "admin_footer-{$hook}.php", [ $this, 'extend_submit_post_status' ] );
		}

    }

    function insert_listing( $post_id, $post, $update ) {

        if ( wp_is_post_revision( $post_id ) ) {
            return;
        }

        if ( $post->post_type !== 'ulz_listing' ) {
            return;
        }

        // make sure the listing owns priority meta
        if( ! metadata_exists( 'post', $post_id, 'ulz_priority' ) ) {
            add_post_meta( $post_id, 'ulz_priority', 0 );
        }

    }

    function register_post_types() {

        $is_multisite = is_multisite();
        $capability_create = $is_multisite ? 'do_not_allow' : false;

        // post types
		$singular = esc_html__( 'Listing Type', 'utillz-core' );
		$plural = esc_html__( 'Listing Types', 'utillz-core' );

		$rewrite = [
			'slug' => apply_filters('utillz/post-type/listing-type/slug', 'listing-type'),
			'with_front' => false,
			'feeds' => false,
			'pages' => false
		];

		register_post_type( 'ulz_listing_type',
			apply_filters( 'utillz/post_type/listing_type', [
				'labels' => [
					'name' 					=> $plural,
					'singular_name' 		=> $singular,
					'menu_name'             => $plural,
					'all_items'             => sprintf( esc_html__( 'All %s', 'utillz-core' ), $plural ),
					'add_new' 				=> esc_html__( 'Add New', 'utillz-core' ),
					'add_new_item' 			=> sprintf( esc_html__( 'Add %s', 'utillz-core' ), $singular ),
					'edit' 					=> esc_html__( 'Edit', 'utillz-core' ),
					'edit_item' 			=> sprintf( esc_html__( 'Edit %s', 'utillz-core' ), $singular ),
					'new_item' 				=> sprintf( esc_html__( 'New %s', 'utillz-core' ), $singular ),
					'view' 					=> sprintf( esc_html__( 'View %s', 'utillz-core' ), $singular ),
					'view_item' 			=> sprintf( esc_html__( 'View %s', 'utillz-core' ), $singular ),
					'search_items' 			=> sprintf( esc_html__( 'Search %s', 'utillz-core' ), $plural ),
					'not_found' 			=> sprintf( esc_html__( 'No %s found', 'utillz-core' ), $plural ),
					'not_found_in_trash' 	=> sprintf( esc_html__( 'No %s found in trash', 'utillz-core' ), $plural ),
					'parent' 				=> sprintf( esc_html__( 'Parent %s', 'utillz-core' ), $singular ),
				],
                'taxonomies'            => [],
				'menu_icon'             => 'dashicons-admin-settings',
	            'public' 				=> false,
                'publicly_queryable' 	=> false,
				'show_ui' 				=> true,
				'exclude_from_search' 	=> true,
				'hierarchical' 			=> false,
				'rewrite' 				=> $rewrite,
				'query_var' 			=> true,
				'supports' 				=> [ 'title', 'thumbnail' ],
				'has_archive' 			=> false,
				'show_in_nav_menus' 	=> true,
			])
		);

        $singular = esc_html__( 'Listing', 'utillz-core' );
		$plural = esc_html__( 'Listings', 'utillz-core' );

        $listing_slug = esc_attr( get_option('ulz_listing_slug') );

		$rewrite = [
			'slug' => $listing_slug ? $listing_slug : 'listing',
			'with_front' => false,
			'feeds' => false,
			'pages' => false
		];

        $pending_approval = new \WP_Query([
            'post_type' => 'ulz_listing',
            'post_status' => 'pending',
        ]);

		register_post_type( 'ulz_listing',
			apply_filters( 'utillz/post_type/listing', [
				'labels' => [
					'name' 					=> $plural,
					'singular_name' 		=> $singular,
					'menu_name'             => $plural,
					'all_items'             => sprintf( esc_html__( 'All %s%s', 'utillz-core' ), $plural, $pending_approval->found_posts ? ' <span class="awaiting-mod">' . (int) $pending_approval->found_posts . '</span>' : '' ),
					'add_new' 				=> esc_html__( 'Add New', 'utillz-core' ),
					'add_new_item' 			=> sprintf( esc_html__( 'Add %s', 'utillz-core' ), $singular ),
					'edit' 					=> esc_html__( 'Edit', 'utillz-core' ),
					'edit_item' 			=> sprintf( esc_html__( 'Edit %s', 'utillz-core' ), $singular ),
					'new_item' 				=> sprintf( esc_html__( 'New %s', 'utillz-core' ), $singular ),
					'view' 					=> sprintf( esc_html__( 'View %s', 'utillz-core' ), $singular ),
					'view_item' 			=> sprintf( esc_html__( 'View %s', 'utillz-core' ), $singular ),
					'search_items' 			=> sprintf( esc_html__( 'Search %s', 'utillz-core' ), $plural ),
					'not_found' 			=> sprintf( esc_html__( 'No %s found', 'utillz-core' ), $plural ),
					'not_found_in_trash' 	=> sprintf( esc_html__( 'No %s found in trash', 'utillz-core' ), $plural ),
					'parent' 				=> sprintf( esc_html__( 'Parent %s', 'utillz-core' ), $singular ),
				],
                'taxonomies'            => [],
				'menu_icon'             => 'dashicons-location',
				'public' 				=> true,
                'publicly_queryable' 	=> true,
				'show_ui' 				=> true,
				'exclude_from_search' 	=> true,
				'hierarchical' 			=> false,
				'rewrite' 				=> $rewrite,
				'query_var' 			=> true,
				'supports' 				=> [ 'title', 'thumbnail', 'author', 'comments' ],
				'has_archive' 			=> false,
				'show_in_nav_menus' 	=> true,
			])
		);

        $singular = esc_html__( 'Search Form', 'utillz-core' );
		$plural = esc_html__( 'Search Forms', 'utillz-core' );

		$rewrite = [
			'slug' => apply_filters('utillz/post-type/search-forms/slug', 'search-forms'),
			'with_front' => false,
			'feeds' => false,
			'pages' => false
		];

		register_post_type( 'ulz_search_form',
			apply_filters( 'utillz/post_type/search_form', [
				'labels' => [
					'name' 					=> $plural,
					'singular_name' 		=> $singular,
					'menu_name'             => $plural,
					'all_items'             => sprintf( esc_html__( '%s', 'utillz-core' ), $plural ),
					'add_new' 				=> esc_html__( 'Add New', 'utillz-core' ),
					'add_new_item' 			=> sprintf( esc_html__( 'Add %s', 'utillz-core' ), $singular ),
					'edit' 					=> esc_html__( 'Edit', 'utillz-core' ),
					'edit_item' 			=> sprintf( esc_html__( 'Edit %s', 'utillz-core' ), $singular ),
					'new_item' 				=> sprintf( esc_html__( 'New %s', 'utillz-core' ), $singular ),
					'view' 					=> sprintf( esc_html__( 'View %s', 'utillz-core' ), $singular ),
					'view_item' 			=> sprintf( esc_html__( 'View %s', 'utillz-core' ), $singular ),
					'search_items' 			=> sprintf( esc_html__( 'Search %s', 'utillz-core' ), $plural ),
					'not_found' 			=> sprintf( esc_html__( 'No %s found', 'utillz-core' ), $plural ),
					'not_found_in_trash' 	=> sprintf( esc_html__( 'No %s found in trash', 'utillz-core' ), $plural ),
					'parent' 				=> sprintf( esc_html__( 'Parent %s', 'utillz-core' ), $singular ),
				],
                'taxonomies'            => [],
                'show_in_menu'          => 'edit.php?post_type=ulz_listing_type',
                'capability_type'       => 'page',
				'public' 				=> false,
                'publicly_queryable' 	=> false,
				'show_ui' 				=> true,
				'exclude_from_search' 	=> true,
				'hierarchical' 			=> false,
				'rewrite' 				=> $rewrite,
				'query_var' 			=> true,
				'supports' 				=> [ 'title' ],
				'has_archive' 			=> false,
				'show_in_nav_menus' 	=> false,
			])
		);

        $singular = esc_html__( 'Entry', 'utillz-core' );
		$plural = esc_html__( 'Entries', 'utillz-core' );

		$rewrite = [
			'slug' => apply_filters('utillz/post-type/entry/slug', 'entry'),
			'with_front' => false,
			'feeds' => false,
			'pages' => false
		];

		register_post_type( 'ulz_entry',
			apply_filters( 'utillz/post_type/entry', [
				'labels' => [
					'name' 					=> $plural,
					'singular_name' 		=> $singular,
					'menu_name'             => $plural,
					'all_items'             => sprintf( esc_html__( '%s', 'utillz-core' ), $plural ),
					'add_new' 				=> esc_html__( 'Add New', 'utillz-core' ),
					'add_new_item' 			=> sprintf( esc_html__( 'Add %s', 'utillz-core' ), $singular ),
					'edit' 					=> esc_html__( 'Edit', 'utillz-core' ),
					'edit_item' 			=> sprintf( esc_html__( 'Edit %s', 'utillz-core' ), $singular ),
					'new_item' 				=> sprintf( esc_html__( 'New %s', 'utillz-core' ), $singular ),
					'view' 					=> sprintf( esc_html__( 'View %s', 'utillz-core' ), $singular ),
					'view_item' 			=> sprintf( esc_html__( 'View %s', 'utillz-core' ), $singular ),
					'search_items' 			=> sprintf( esc_html__( 'Search %s', 'utillz-core' ), $plural ),
					'not_found' 			=> sprintf( esc_html__( 'No %s found', 'utillz-core' ), $plural ),
					'not_found_in_trash' 	=> sprintf( esc_html__( 'No %s found in trash', 'utillz-core' ), $plural ),
					'parent' 				=> sprintf( esc_html__( 'Parent %s', 'utillz-core' ), $singular ),
				],
                'taxonomies'            => [],
                'show_in_menu'          => 'edit.php?post_type=ulz_listing_type',
				'public' 				=> false,
                'publicly_queryable' 	=> false,
				'show_ui' 				=> true,
				'exclude_from_search' 	=> true,
				'hierarchical' 			=> false,
				'rewrite' 				=> $rewrite,
				'query_var' 			=> true,
				'supports' 				=> [ 'title', 'author' ],
				'has_archive' 			=> false,
				'show_in_nav_menus' 	=> true,

                'capability_type'       => 'post',
                'capabilities' => [
                    'create_posts' => $capability_create,
                ],
                'map_meta_cap'          => true,
			])
		);

        $singular = esc_html__( 'Collection', 'utillz-core' );
		$plural = esc_html__( 'Collections', 'utillz-core' );

		$rewrite = [
			'slug' => apply_filters('utillz/post-type/collection/slug', 'collection'),
			'with_front' => true,
			'feeds' => false,
			'pages' => false
		];

		register_post_type( 'ulz_collection',
			apply_filters( 'utillz/post_type/collection', [
				'labels' => [
					'name' 					=> $plural,
					'singular_name' 		=> $singular,
					'menu_name'             => $plural,
					'all_items'             => sprintf( esc_html__( '%s', 'utillz-core' ), $plural ),
					'add_new' 				=> esc_html__( 'Add New', 'utillz-core' ),
					'add_new_item' 			=> sprintf( esc_html__( 'Add %s', 'utillz-core' ), $singular ),
					'edit' 					=> esc_html__( 'Edit', 'utillz-core' ),
					'edit_item' 			=> sprintf( esc_html__( 'Edit %s', 'utillz-core' ), $singular ),
					'new_item' 				=> sprintf( esc_html__( 'New %s', 'utillz-core' ), $singular ),
					'view' 					=> sprintf( esc_html__( 'View %s', 'utillz-core' ), $singular ),
					'view_item' 			=> sprintf( esc_html__( 'View %s', 'utillz-core' ), $singular ),
					'search_items' 			=> sprintf( esc_html__( 'Search %s', 'utillz-core' ), $plural ),
					'not_found' 			=> sprintf( esc_html__( 'No %s found', 'utillz-core' ), $plural ),
					'not_found_in_trash' 	=> sprintf( esc_html__( 'No %s found in trash', 'utillz-core' ), $plural ),
					'parent' 				=> sprintf( esc_html__( 'Parent %s', 'utillz-core' ), $singular ),
				],
                'taxonomies'            => [ 'ulz_listing_tag' ],
                'show_in_menu'          => 'edit.php?post_type=ulz_listing_type',
				'public' 				=> true,
                'publicly_queryable' 	=> true,
				'show_ui' 				=> true,
				'exclude_from_search' 	=> true,
				'hierarchical' 			=> false,
				'rewrite' 				=> $rewrite,
				'query_var' 			=> true,
				'supports' 				=> [ 'title', 'author', 'thumbnail' ],
				'has_archive' 			=> true,
				'show_in_nav_menus' 	=> true,

                'capability_type'       => 'post',
                'map_meta_cap'          => true,
			])
		);

        $singular = esc_html__( 'Report', 'utillz-core' );
		$plural = esc_html__( 'Reports', 'utillz-core' );

		$rewrite = [
			'slug' => apply_filters('utillz/post-type/report/slug', 'report'),
			'with_front' => false,
			'feeds' => false,
			'pages' => false
		];

		register_post_type( 'ulz_report',
			apply_filters( 'utillz/post_type/report', [
				'labels' => [
					'name' 					=> $plural,
					'singular_name' 		=> $singular,
					'menu_name'             => $plural,
					'all_items'             => sprintf( esc_html__( '%s', 'utillz-core' ), $plural ),
					'add_new' 				=> esc_html__( 'Add New', 'utillz-core' ),
					'add_new_item' 			=> sprintf( esc_html__( 'Add %s', 'utillz-core' ), $singular ),
					'edit' 					=> esc_html__( 'Edit', 'utillz-core' ),
					'edit_item' 			=> sprintf( esc_html__( 'Edit %s', 'utillz-core' ), $singular ),
					'new_item' 				=> sprintf( esc_html__( 'New %s', 'utillz-core' ), $singular ),
					'view' 					=> sprintf( esc_html__( 'View %s', 'utillz-core' ), $singular ),
					'view_item' 			=> sprintf( esc_html__( 'View %s', 'utillz-core' ), $singular ),
					'search_items' 			=> sprintf( esc_html__( 'Search %s', 'utillz-core' ), $plural ),
					'not_found' 			=> sprintf( esc_html__( 'No %s found', 'utillz-core' ), $plural ),
					'not_found_in_trash' 	=> sprintf( esc_html__( 'No %s found in trash', 'utillz-core' ), $plural ),
					'parent' 				=> sprintf( esc_html__( 'Parent %s', 'utillz-core' ), $singular ),
				],
                'taxonomies'            => [],
                'show_in_menu'          => 'edit.php?post_type=ulz_listing_type',
				'public' 				=> false,
                'publicly_queryable' 	=> false,
				'show_ui' 				=> true,
				'exclude_from_search' 	=> true,
				'hierarchical' 			=> false,
				'rewrite' 				=> $rewrite,
				'query_var' 			=> true,
				'supports' 				=> [ 'title' ],
				'has_archive' 			=> false,
				'show_in_nav_menus' 	=> true,

                'capability_type'       => 'post',
                'capabilities' => [
                    'create_posts' => $capability_create,
                ],
                'map_meta_cap'          => true,
			])
		);

        $singular = esc_html__( 'Conversation', 'utillz-core' );
		$plural = esc_html__( 'Conversations', 'utillz-core' );

		$rewrite = [
			'slug' => apply_filters('utillz/post-type/conversation/slug', 'conversation'),
			'with_front' => false,
			'feeds' => false,
			'pages' => false
		];

		register_post_type( 'ulz_conversation',
			apply_filters( 'utillz/post_type/conversation', [
				'labels' => [
					'name' 					=> $plural,
					'singular_name' 		=> $singular,
					'menu_name'             => $plural,
					'all_items'             => sprintf( esc_html__( '%s', 'utillz-core' ), $plural ),
					'add_new' 				=> esc_html__( 'Add New', 'utillz-core' ),
					'add_new_item' 			=> sprintf( esc_html__( 'Add %s', 'utillz-core' ), $singular ),
					'edit' 					=> esc_html__( 'Edit', 'utillz-core' ),
					'edit_item' 			=> sprintf( esc_html__( 'Edit %s', 'utillz-core' ), $singular ),
					'new_item' 				=> sprintf( esc_html__( 'New %s', 'utillz-core' ), $singular ),
					'view' 					=> sprintf( esc_html__( 'View %s', 'utillz-core' ), $singular ),
					'view_item' 			=> sprintf( esc_html__( 'View %s', 'utillz-core' ), $singular ),
					'search_items' 			=> sprintf( esc_html__( 'Search %s', 'utillz-core' ), $plural ),
					'not_found' 			=> sprintf( esc_html__( 'No %s found', 'utillz-core' ), $plural ),
					'not_found_in_trash' 	=> sprintf( esc_html__( 'No %s found in trash', 'utillz-core' ), $plural ),
					'parent' 				=> sprintf( esc_html__( 'Parent %s', 'utillz-core' ), $singular ),
				],
                'taxonomies'            => [],
                'show_in_menu'          => 'edit.php?post_type=ulz_listing_type',
				'public' 				=> false,
                'publicly_queryable' 	=> false,
				'show_ui' 				=> true,
				'exclude_from_search' 	=> true,
				'hierarchical' 			=> false,
				'rewrite' 				=> $rewrite,
				'query_var' 			=> true,
				// 'supports' 				=> [ 'title', 'author' ],
				'supports' 				=> [ 'title' ],
				'has_archive' 			=> false,
				'show_in_nav_menus' 	=> true,
                'capability_type'       => 'post',
                'capabilities' => [
                    'create_posts' => $capability_create,
                ],
                'map_meta_cap'          => true,
			])
		);

    }

    public function register_post_status() {

        register_post_status( 'pending_payment', [
			'label' => _x( 'Pending Payment', 'post status', 'utillz-core' ),
			'public' => true,
			'exclude_from_search' => false,
			'show_in_admin_all_list' => true,
			'show_in_admin_status_list' => true,
			'label_count' => _n_noop( 'Pending Payment <span class="count">(%s)</span>', 'Pending Payment <span class="count">(%s)</span>', 'utillz-core' ),
		]);

        register_post_status( 'expired', [
			'label' => _x( 'Expired', 'post status', 'utillz-core' ),
			'public' => true,
			// 'protected' => true,
			'exclude_from_search' => false,
			'show_in_admin_all_list' => true,
			'show_in_admin_status_list' => true,
			'label_count' => _n_noop( 'Expired <span class="count">(%s)</span>', 'Expired <span class="count">(%s)</span>', 'utillz-core' ),
		]);

        register_post_status( 'declined', [
			'label' => _x( 'Declined', 'post status', 'utillz-core' ),
			'public' => true,
			// 'protected' => true,
			'exclude_from_search' => false,
			'show_in_admin_all_list' => true,
			'show_in_admin_status_list' => true,
			'label_count' => _n_noop( 'Declined <span class="count">(%s)</span>', 'Declined <span class="count">(%s)</span>', 'utillz-core' ),
		]);

        register_post_status( 'cancelled', [
			'label' => _x( 'Cancelled', 'post status', 'utillz-core' ),
			'public' => true,
			// 'protected' => true,
			'exclude_from_search' => false,
			'show_in_admin_all_list' => true,
			'show_in_admin_status_list' => true,
			'label_count' => _n_noop( 'Cancelled <span class="count">(%s)</span>', 'Cancelled <span class="count">(%s)</span>', 'utillz-core' ),
		]);
		
		register_post_status( 'pending_listing', [
            'label' => _x( 'pending listing', 'post status', 'utillz-core' ),
            'public' => true,
            'exclude_from_search' => false,
            'show_in_admin_all_list' => true,
            'show_in_admin_status_list' => true,
            'label_count' => _n_noop( 'Pending listing <span class="count">(%s)</span>', 'Pending Listing <span class="count">(%s)</span>', 'utillz-core' ),
        ]);
		

    }

    public function approve_listing() {

        if (
            isset( $_GET['approve_listing'] ) &&
            wp_verify_nonce( $_REQUEST['_wpnonce'], 'approve_listing' ) &&
            current_user_can( 'publish_post', $_GET['approve_listing'] )
        ) {

			$post_id = (int) $_GET['approve_listing'];
			$data = [
				'ID' => $post_id,
				'post_status' => 'publish',
			];

            // notify
			utillz_core()->notify->distribute( 'listing-approved', [
				'user_id' => get_post_field( 'post_author', $post_id ),
				'meta' => [
                    'listing_id' => $post_id,
                ],
			]);

            wp_update_post( $data );
            wp_redirect( admin_url( 'edit.php?post_type=ulz_listing' ) );
            exit;

		}

	}

    public function extend_submit_post_status() {

        global $post, $post_type;

		if ( $post_type !== 'ulz_listing' ) {
			return;
		}

		$options = $display = '';
		foreach( Ucore()->get_listing_statuses() as $status => $name ) {
			$selected = selected( $post->post_status, $status, false );
			if ( $selected ) {
				$display = $name;
			}
			$options .= "<option{$selected} value='{$status}'>" . esc_html( $name ) . '</option>';
		}

		?>
    		<script type="text/javascript">
    			jQuery( document ).ready( function($) {
    				<?php if ( ! empty( $display ) ) : ?>
    					jQuery( '#post-status-display' ).html( decodeURIComponent( '<?php echo rawurlencode( (string) wp_specialchars_decode( $display ) ); ?>' ) );
    				<?php endif; ?>
    				var select = jQuery( '#post-status-select' ).find( 'select' );
    				jQuery( select ).html( decodeURIComponent( '<?php echo rawurlencode( (string) wp_specialchars_decode( $options ) ); ?>' ) );
    			} );
    		</script>
		<?php

	}

    public function listing_status_change( $post_id ) {

        if( get_post_type( $post_id ) == 'ulz_listing' ) {

            $listing = new \UtillzCore\Inc\Src\Listing\Listing( $post_id );
            $image = $gallery_attrs = Ucore()->jsoning( 'ulz_gallery', $listing->id );

            if( ! $listing->type->get('ulz_gallery_as_featured') ) {
                return;
            }

            if( ! $listing->id ) {
                return;
            }

            if( isset( $image[0] ) && isset( $image[0]->id ) ) {
                set_post_thumbnail( $listing->id, $image[0]->id );
            }

        }

    }

}
